//
//  B5UserAccount.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-03-24.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>

// Notifications posted by B5UserAccount
FOUNDATION_EXPORT NSString *B5UserAccountWillLockNotification;
FOUNDATION_EXPORT NSString *B5UserAccountDidLockNotification;
FOUNDATION_EXPORT NSString *B5UserAccountDidUnlockNotification;
FOUNDATION_EXPORT NSString *B5UserAccountDidAuthenticateNotification;

// Login Dictionary Keys
FOUNDATION_EXPORT NSString const * B5UserAccountLoginEmailKey;
FOUNDATION_EXPORT NSString const * B5UserAccountLoginPersonalKeyKey;
FOUNDATION_EXPORT NSString const * B5UserAccountLoginSRPComputedXDictionaryKey;
FOUNDATION_EXPORT NSString const * B5UserAccountLoginMasterUnlockKeyKey;

FOUNDATION_EXPORT NSString *B5UserAccountProfileUnlockedNotification;

FOUNDATION_EXPORT NSString * const B5UserAccountBillingStatusDidChangeNotification;

FOUNDATION_EXPORT NSString *B5UserAccountStateRegistered;
FOUNDATION_EXPORT NSString *B5UserAccountStateActive;
FOUNDATION_EXPORT NSString *B5UserAccountStateSuspended;
FOUNDATION_EXPORT NSString *B5UserAccountStateDeleted;

FOUNDATION_EXPORT NSString * const B5UserAccountTypeTeam;
FOUNDATION_EXPORT NSString * const B5UserAccountTypeFamily;
FOUNDATION_EXPORT NSString * const B5UserAccountTypeIndividual;

@class OPPersonalKey;
@class OPKeySet;
@class OPSymmetricKey;
@class B5EncryptedKeySet;
@class B5Profile;
@class B5VaultAccess;
@class B5Category;
@class B5UserAccountBillingOverview;
@class B5UserAccountUserOverview;

@interface B5UserAccount : B5DatabaseObject

+ (instancetype)userAccountWithEmail:(NSString *)email server:(NSString *)server;
+ (NSString *)prehashPassword:(NSString *)passwordString; // soft deprecated. should only ever be called in the case of `PBES2-HS256`
+ (BOOL)isServerURL:(NSString *)server1 onSameServerAsServerURL:(NSString *)server2; // returns YES if both server URLs have same suffixes (e.g. .1password.com)
+ (NSString *)transformServerURL:(NSString *)serverURLString withChangedDomain:(NSString *)changedDomain;

#pragma mark - Database Properties

@property (atomic) OPTimestamp lastAuthAt;
@property (nonatomic, copy) NSString *userUUID;
@property (nonatomic, copy) NSString *accountUUID;
@property (nonatomic, copy) NSString *email;
@property (nonatomic, copy) NSString *avatar; // userAvatar
@property (nonatomic, copy) NSString *firstName;
@property (nonatomic, copy) NSString *lastName;
@property (nonatomic, readonly) NSString *fullName;
@property (nonatomic, copy) NSString *server;
@property (nonatomic, assign) NSUInteger userVersion;
@property (nonatomic, assign) NSUInteger accountVersion;
@property (nonatomic, assign) NSUInteger templateVersion;
@property (nonatomic, assign) NSUInteger keySetVersion;
@property (nonatomic, copy) NSString *accountType; // enum?
@property (nonatomic, copy) NSString *accountState; // enum?
@property (nonatomic, copy) NSString *accountName; // enum?
@property (nonatomic, copy) NSString *accountAvatar; // teamAvatar
@property (nonatomic, copy) NSData *encryptedLogin; // JSON dictionary, encrypted with OP4Database Primary Profile Key
@property (nonatomic, copy) NSString *baseAttachmentURLString;
@property (nonatomic, copy) NSString *baseAvatarURLString;

#pragma mark - Database Relationships
@property (nonatomic, strong) B5PersonalKey *personalKey;
@property (nonatomic, copy) NSArray *encryptedKeySets;

#pragma mark -
@property (readonly) B5EncryptedKeySet *activeEncryptedUserKeySet;
@property (nonatomic, readonly, strong) OPKeySet *activeUserKeySet; // only available when unlocked

@property (nonatomic, readonly, copy) NSDictionary *SRPComputedXDictionary; // only available when having been unlocked via -unlockWithLoginDictionary
@property (nonatomic, readonly) NSDictionary *loginDictionary; // only available when unlocked
@property (readonly, getter=isLocked) BOOL locked;

@property (nonatomic, assign, getter=isSyncable) BOOL syncable; // Defaults to YES, when set to NO OPProfileSyncMonitor will refuse to sync.

#pragma mark -  monitors web socket for sync notifications
@property (nonatomic, readonly) NSURL *b5ServerNotificationURL;

#pragma mark -  Billing information
@property (nonatomic) B5UserAccountBillingOverview *billingOverview;
@property (nonatomic, readonly, getter=isFrozen) BOOL frozen;

#pragma mark - User overview (Access permissions here)

@property (nonatomic) B5UserAccountUserOverview *userOverview;

#pragma mark

- (void)lock;
- (BOOL)unlockWithLoginDictionary:(NSDictionary *)accountLoginDictionary;
- (BOOL)unlockWithPassword:(NSString *)accountPasswordHash;
- (BOOL)isPasswordValid:(NSString *)prehashPassword;

#pragma mark -  Will only work when user account is unlocked
- (BOOL)refreshKeySets; // will re-evalute encryptedKeySets to determine activeUserKeySet and decrypt the chain again
- (BOOL)unlockProfile:(B5Profile *)profile usingVaultAccess:(B5VaultAccess *)vaultAccess;

#pragma mark -  Category Cache
- (B5Category *)categoryWithUUID:(NSString *)uuid;
- (void)addCategory:(B5Category *)category;
- (void)removeCategoryWithUUID:(NSString *)uuid;
- (void)removeAllCategories;
- (NSArray *)allCategories;

@end
